% Function returns the root of phi(z)=lambda

function root_new = root(mu, sigma, up_weight, down_weight, up_exp, down_exp, up_freq,down_freq, lambda) 
% syms z
% 
% root = solve(0.5 * sigma^2 * z^2 + mu * z + up_freq * dot(up_weight, z./(up_exp-z)) - down_freq *  dot(down_weight, z./(down_exp + z))== lambda,z);
if sum(up_freq)== 0 && sum(down_freq)== 0
    p = [0.5*sigma^2, mu, -lambda];
    root_new = roots(p);
else 
    fun = @(z) phi(mu, sigma, up_weight, down_weight, up_exp, down_exp, up_freq,down_freq,z)-lambda; 
    x0 = [-2 * max(down_exp),sort([-([0,down_exp(1:end-1)]+ down_exp) / 2,  ([0,up_exp(1:end-1)]+ up_exp) / 2]), 2 * max(up_exp)]'; 
    root_new = zeros(length(x0),1);
for i = 1: length(x0)
    root_new(i) = fzero(fun,x0(i));
end

end