% [put, call] = knock_out(mu, sigma, up_weight, down_weight, up_exp,
% down_exp, up_freq,down_freq, lambda, K,  L, S_initial) returns the price 
% of knock_out call and put. Expiration data is assumed to have exp(lambda)
% distribution.If S_initial is smaller than L, it should be a up and out
% option, whose payoff function is I[S_initial*exp(M(tau)<L]*b(S(tau),
% where I[] is an indicator function and b() is a payoff function of call
% or put. Otherwise, it will be a down and out option, whose payoff function
% is I[S_initial*exp(m(tau)>L]*b(S(tau).M(tau) and m(tau) denotes the max
% and min value of X(tau) between 0 and tau. I calculate the price of
% up_and_out option through up_and_in. 



function [put, call] = knock_out(mu, sigma, up_weight, down_weight, up_exp, down_exp, up_freq,down_freq, lambda0, K,  L, S_initial)
    [vanilla_put, vanilla_call] =  vanilla(mu, sigma, up_weight, down_weight, up_exp, down_exp, up_freq,down_freq, lambda0, K, S_initial); 
    [knock_in_put, knock_in_call] =  knock_in(mu, sigma, up_weight, down_weight, up_exp, down_exp, up_freq,down_freq, lambda0, K,  L, S_initial);
              put = vanilla_put - knock_in_put;
              call = vanilla_call - knock_in_call;
end