
% [put, call]= fixed_lookback(mu, sigma, up_weight, down_weight, up_exp,
% down_exp, up_freq,down_freq, lambda, K, H, S_initial) returns the price of
% fixed_lookback call and put. Expiration data is assumed to have
% exp(lambda) distribution. The payoff function of fixed-lookback call is
% [max(H,S_initial*exp(M(tau))-K]+, where M(tau) denotes the max value of
% X(tau) between 0 and tau
function [put, call]= fixed_lookback(mu, sigma, up_weight, down_weight, up_exp, down_exp, up_freq,down_freq, lambda0, K, H, S_initial)

[alpha, beta] = return_alpha_beta(mu, sigma, up_weight, down_weight, up_exp, down_exp, up_freq,down_freq, lambda0);
[a_star, b_star] = return_star(mu, sigma, up_weight, down_weight, up_exp, down_exp, up_freq,down_freq, lambda0);

if K <= H
    put = sum(a_star.* eta(alpha,K,S_initial));
    call = sum(b_star.* eta(beta,H,S_initial)) - K + H;
else
    call = sum(b_star.* eta(beta,K,S_initial));
    put = sum(a_star.* eta(alpha, H, S_initial)) + K - H;

end



function y = eta(h,K,S_initial)
y=S_initial.^h .* K.^(1-h)./(h.*(h-1)); 


