function [lambda,linear_coeff] = fit_nonlinear(lambda_0,t,data,x,l_b)

warning('off');
y = empirical_distribution(t, data, x); 

F2 = @(x,t) fitvector(x,t,y);

% fitting exponential part
options = optimoptions(@lsqcurvefit,'MaxFunEvals',200000,'MaxIter', 500000, 'Algorithm','levenberg-marquardt');
lb = l_b * ones(1,length(lambda_0));
ub = [];

[lambda] = lsqcurvefit(F2,lambda_0,t',y,lb,ub,options);

% fitting linear part
A = zeros(length(t),length(lambda));  
for j = 1:length(lambda)
   A(:,j) = exp(-lambda(j)*t');
end
B  = ones(1,length(lambda));
d  = 1;
linear_coeff = lsqlin(A,y,[],[],B,d,[],[])';



function new_y = fitvector(lambda,xdata,ydata)

A = zeros(length(xdata),length(lambda)); 
for j = 1:length(lambda)
   A(:,j) = exp(-lambda(j)*xdata);
end


B  = ones(1,length(lambda));
d  = 1;
c = lsqlin(A,ydata,[],[],B,d,[],[]);
new_y = A*c; 